# CloudGuard Portfolio: Account Creation Automation Guide

This guide explains how to use the provided Python script to automate the creation of AWS accounts in your organization. This is particularly useful for creating the "just-in-time" workload accounts as you progress through your certification journey.

---

## 1. Introduction

Manually creating accounts through the AWS Console is straightforward but time-consuming. The provided `create_aws_account.py` script automates the entire process, including moving the account to the correct Organizational Unit (OU). This demonstrates infrastructure-as-code principles and operational efficiency.

---

## 2. Prerequisites

Before using the automation script, ensure you have the following:

-   **AWS CLI Configured:** Your AWS CLI must be configured with credentials that have permissions to create accounts and manage AWS Organizations. These credentials should be for your management account.
-   **Python 3 Installed:** The script requires Python 3.6 or later.
-   **boto3 Library Installed:** Install the AWS SDK for Python by running:
    ```bash
    pip install boto3
    ```

---

## 3. Script Usage

The script is located at `create_aws_account.py` and accepts the following command-line arguments:

| Argument | Required | Description | Example |
| :--- | :---: | :--- | :--- |
| `--name` | Yes | The name of the AWS account to create. | `cloudguard-workloads-ml-01` |
| `--email` | Yes | The email address for the account's root user. | `your.email+cloudguard-workloads-ml-01@gmail.com` |
| `--ou` | Yes | The name of the Organizational Unit to move the account to. | `Workloads` |
| `--region` | No | AWS region to use for API calls (default: `us-east-1`). | `us-west-2` |

---

## 4. Example: Creating the ML Workload Account

Let's create the first workload account for your ML Engineer Associate certification.

**Command:**

```bash
python3 create_aws_account.py \
  --name cloudguard-workloads-ml-01 \
  --email your.email+cloudguard-workloads-ml-01@gmail.com \
  --ou Workloads
```

**Expected Output:**

```
Creating account: cloudguard-workloads-ml-01
Email: your.email+cloudguard-workloads-ml-01@gmail.com
Account creation initiated. Request ID: car-xxxxxxxxxxxx
Waiting for account creation to complete...
Status: IN_PROGRESS... (waiting)
✅ Account created successfully! Account ID: 123456789012
Found OU 'Workloads' with ID: ou-xxxx-xxxxxxxx
Moving account 123456789012 to OU ou-xxxx-xxxxxxxx...
✅ Account moved successfully!

============================================================
🎉 SUCCESS! Account setup complete.
============================================================
Account Name: cloudguard-workloads-ml-01
Account ID: 123456789012
OU: Workloads
Email: your.email+cloudguard-workloads-ml-01@gmail.com
============================================================
```

The script will:
1.  Initiate the account creation request.
2.  Poll the status until the account is created (typically 1-3 minutes).
3.  Automatically move the account from the Root OU to the specified `Workloads` OU.

---

## 5. Creating All Workload Accounts

You can use the script to create all five workload accounts. Here are the commands for each:

**ML Engineering Account (February):**
```bash
python3 create_aws_account.py \
  --name cloudguard-workloads-ml-01 \
  --email your.email+cloudguard-workloads-ml-01@gmail.com \
  --ou Workloads
```

**Security Labs Account (March):**
```bash
python3 create_aws_account.py \
  --name cloudguard-workloads-security-01 \
  --email your.email+cloudguard-workloads-security-01@gmail.com \
  --ou Workloads
```

**App Architecture Account (April):**
```bash
python3 create_aws_account.py \
  --name cloudguard-workloads-app-arch-01 \
  --email your.email+cloudguard-workloads-app-arch-01@gmail.com \
  --ou Workloads
```

**CI/CD Pipelines Account (May):**
```bash
python3 create_aws_account.py \
  --name cloudguard-workloads-cicd-01 \
  --email your.email+cloudguard-workloads-cicd-01@gmail.com \
  --ou Workloads
```

**Generative AI Account (June):**
```bash
python3 create_aws_account.py \
  --name cloudguard-workloads-genai-01 \
  --email your.email+cloudguard-workloads-genai-01@gmail.com \
  --ou Workloads
```

---

## 6. Troubleshooting

**Error: "Account creation failed. Reason: EMAIL_ALREADY_EXISTS"**
-   **Solution:** Each AWS account requires a unique email address. Double-check that you're using the correct email alias and that it hasn't been used for another account.

**Error: "OU 'Workloads' not found."**
-   **Solution:** Ensure you've created the `Workloads` OU as described in the `AWS_ORGANIZATIONS_SETUP_GUIDE.md`. The OU name is case-sensitive.

**Error: "An error occurred (AccessDeniedException)..."**
-   **Solution:** Your AWS credentials don't have the necessary permissions. Ensure you're using credentials from the management account with `organizations:*` permissions.

---

## 7. Next Steps

With your accounts created and organized, you're ready to start building your projects!

-   **Configure IAM Identity Center access** for the new accounts (refer to `AWS_IAM_IDENTITY_CENTER_GUIDE.md`).
-   **Set up billing alerts** for each account to monitor costs.
-   **Begin your first certification project** in the appropriate workload account.

---

This automation script is a valuable addition to your portfolio, demonstrating your ability to work with infrastructure as code and AWS APIs.
