# CloudGuard Portfolio: AWS Account Strategy & Naming Conventions

This document outlines the total number of AWS accounts required for the CloudGuard Portfolio project, a professional naming convention, and the strategic purpose of each account.

---

## 1. Total Account Count

Based on the "Foundation-First" and "Just-in-Time" strategy, you will create a total of **11 AWS accounts**. This includes the initial management account and 10 member accounts created within the AWS Organization.

| Account Category | Count | Description |
| :--- | :--- | :--- |
| **Foundation Accounts** | 6 | Core infrastructure, security, and management. Created once. |
| **Workload Accounts** | 5 | Ephemeral, project-specific accounts for certifications. Created and decommissioned. |
| **Total** | **11** | Complete multi-account environment. |

This structure provides a robust, secure, and cost-effective environment that mirrors enterprise best practices.

---

## 2. Naming Convention Standard

A consistent naming convention is critical for management and clarity. We will use the following format for both account names and email aliases.

**Format:** `cloudguard-[ou]-[purpose]`

- **`cloudguard`**: The root identifier for your entire project.
- **`[ou]`**: The Organizational Unit the account belongs to (e.g., `foundation`, `workloads`, `sandbox`).
- **`[purpose]`**: A short, descriptive name for the account's function (e.g., `security`, `networking`, `ml-labs`).

**Email Alias Convention:**
To manage communications for all accounts from a single inbox, use the `+` alias feature of your email provider (e.g., Gmail, Outlook).

- **Your Base Email:** `your.email@gmail.com`
- **Alias Format:** `your.email+cloudguard-[ou]-[purpose]@gmail.com`

---

## 3. Complete Account List & Naming

Here is the definitive list of all 11 accounts with their official names and email aliases.

### Foundational Accounts (OU: `foundation`)

These 6 accounts form the core of your AWS Organization and should not be deleted.

| # | Purpose | Account Name | Email Alias `your.email+...@gmail.com` |
|:-:| :--- | :--- | :--- |
| 1 | **Management** | `cloudguard-foundation-management` | `+cloudguard-foundation-management` |
| 2 | **Log Archive** | `cloudguard-foundation-logarchive` | `+cloudguard-foundation-logarchive` |
| 3 | **Security Tooling** | `cloudguard-foundation-security` | `+cloudguard-foundation-security` |
| 4 | **Networking** | `cloudguard-foundation-networking` | `+cloudguard-foundation-networking` |
| 5 | **Portfolio Hosting** | `cloudguard-foundation-portfolio` | `+cloudguard-foundation-portfolio` |
| 6 | **Sandbox** | `cloudguard-sandbox-main` | `+cloudguard-sandbox-main` |


### Workload Accounts (OU: `workloads`)

These 5 accounts are created "just-in-time" for each certification focus. They are designed to be ephemeral.

| # | Purpose | Account Name | Email Alias `your.email+...@gmail.com` |
|:-:| :--- | :--- | :--- |
| 7 | **ML Engineering** | `cloudguard-workloads-ml-01` | `+cloudguard-workloads-ml-01` |
| 8 | **Security Labs** | `cloudguard-workloads-security-01` | `+cloudguard-workloads-security-01` |
| 9 | **App Architecture** | `cloudguard-workloads-app-arch-01` | `+cloudguard-workloads-app-arch-01` |
| 10| **CI/CD Pipelines** | `cloudguard-workloads-cicd-01` | `+cloudguard-workloads-cicd-01` |
| 11| **Generative AI** | `cloudguard-workloads-genai-01` | `+cloudguard-workloads-genai-01` |

---

## 4. Strategic Benefits

This naming convention and structure provides several key benefits that are valuable to highlight in your portfolio:

- **Clarity:** Instantly identify an account's purpose and environment from its name.
- **Security:** Isolate workloads and apply specific security policies (SCPs) based on OU.
- **Cost Management:** Track costs per project by tagging accounts and analyzing usage in Cost Explorer.
- **Automation:** Predictable names make it easy to write scripts for account creation, configuration, and decommissioning.
- **Professionalism:** Demonstrates a mature, enterprise-level approach to cloud governance.
