'''# CloudGuard Portfolio: IAM Identity Center (SSO) Configuration Guide

This guide provides a step-by-step walkthrough for configuring AWS IAM Identity Center (formerly AWS Single Sign-On) for your CloudGuard Portfolio organization. This is a critical step for establishing secure, centralized, and manageable access to all your AWS accounts.

---

## 1. Introduction

IAM Identity Center is the recommended approach for managing human user access to AWS accounts and applications. It allows you to create or connect your workforce identities and manage their access centrally across your AWS Organization [1].

**Key Benefits:**

-   **Centralized Access Management:** Manage users and permissions for all accounts from a single place.
-   **No Long-Lived Credentials:** Users get temporary, automatically rotating credentials, which is a major security improvement over static IAM user keys.
-   **Improved User Experience:** Provides a single user portal to access all assigned AWS accounts and roles.
-   **Integration with AWS Organizations:** Seamlessly integrates with your multi-account structure.

This guide will help you set up users, groups, and permission sets to provide role-based access to your accounts.

---

## 2. Prerequisites

-   **AWS Organization Setup:** You must have completed the `AWS_ORGANIZATIONS_SETUP_GUIDE.md`.
-   **Root User Access:** You will need root user access to the management account to enable IAM Identity Center for the first time.

---

## 3. Step-by-Step Configuration

### Step 1: Enable IAM Identity Center

This is a one-time action performed in your management account.

1.  **Log in** to the AWS Management Console of your management account as the **root user**.
2.  Navigate to the **IAM Identity Center** service.
3.  On the splash screen, click **"Enable"**.
4.  You will be guided through a setup wizard. For the identity source, choose **"IAM Identity Center directory"**. This is the simplest option and allows you to create users and groups directly within IAM Identity Center.
5.  Complete the setup. IAM Identity Center will now be enabled for your organization.

### Step 2: Create User Groups

Creating groups is the best practice for managing permissions. You assign permissions to groups, and then add users to those groups.

1.  In the IAM Identity Center console, navigate to **"Groups"** on the left-hand menu.
2.  Click **"Create group"**.
3.  Create the following groups to start:

| Group Name | Description |
| :--- | :--- |
| `AWS-Administrators` | For users who need full administrative access across all accounts. |
| `AWS-PowerUsers` | For users who need broad permissions but not full admin rights (e.g., for development). |
| `AWS-ReadOnly` | For users who only need to view resources and configurations. |
| `AWS-Billing` | For users who need access to billing and cost management data. |

### Step 3: Create Users

Now, create your own user account. You will use this for all your daily work instead of the root user.

1.  In the IAM Identity Center console, navigate to **"Users"** on the left-hand menu.
2.  Click **"Add user"**.
3.  Fill in the user details:
    -   **Username:** e.g., `manus`
    -   **Email address:** Your primary email address.
    -   **First name / Last name:** Your details.
4.  Click **"Next"**.
5.  Add the user to the **`AWS-Administrators`** group.
6.  Click **"Next"** and then **"Add user"**.
7.  You will receive an email invitation to set your password. Follow the link to complete the user setup.

**Security Best Practice:** Log out of the root user and log back in as your new IAM Identity Center user for all subsequent steps.

### Step 4: Create Permission Sets

Permission Sets are templates that define a collection of permissions. They are analogous to IAM Roles.

1.  In the IAM Identity Center console, navigate to **"Permission sets"** under the **"Multi-account permissions"** section.
2.  Click **"Create permission set"**.
3.  Choose **"Predefined permission set"** and create the following:

| Predefined Policy | Permission Set Name (Suggestion) |
| :--- | :--- |
| `AdministratorAccess` | `AWSAdministratorAccess` |
| `PowerUserAccess` | `AWSPowerUserAccess` |
| `ReadOnlyAccess` | `AWSReadOnlyAccess` |
| `Billing` | `AWSBillingAccess` |

This creates permission sets that mirror the standard AWS managed policies.

### Step 5: Assign Groups and Permission Sets to Accounts

This is the final step where you grant access.

1.  In the IAM Identity Center console, navigate to **"AWS accounts"**.
2.  Select the checkbox next to an OU or a specific account. For initial setup, let's assign access to the **`Foundation`** OU.
3.  Click the **"Assign users or groups"** button.
4.  Select the **"Groups"** tab.
5.  Check the box next to the **`AWS-Administrators`** group and click **"Next"**.
6.  Select the **`AWSAdministratorAccess`** permission set and click **"Next"**.
7.  Review the assignment and click **"Submit"**. IAM Identity Center will now provision the necessary roles in all accounts within the `Foundation` OU.

Repeat this process to grant different levels of access as needed. For example, you might grant the `AWS-ReadOnly` group access to all accounts in the `Workloads` OU.

---

## 4. Accessing Your Accounts

Once the setup is complete, you can access your accounts via the AWS access portal.

1.  Navigate to the **AWS access portal URL** found on the IAM Identity Center dashboard.
2.  Log in with your newly created user credentials.
3.  You will see a list of all the AWS accounts and roles you have been assigned.
4.  Click on an account/role combination to get one-click access to the AWS Management Console or to get temporary command-line credentials.

---

## 5. Next Steps

Your organization now has a secure and scalable access management foundation. The next step is to automate the creation of your workload accounts.

-   **Proceed to the `AWS_ACCOUNT_AUTOMATION_GUIDE.md`** to learn how to script the creation of your "just-in-time" workload accounts using the AWS CLI or SDK.

---

## References

[1] AWS. (2023). *What is IAM Identity Center?* AWS IAM Identity Center User Guide. [https://docs.aws.amazon.com/singlesignon/latest/userguide/what-is.html](https://docs.aws.amazon.com/singlesignon/latest/userguide/what-is.html)
'''))<execute_tool>print(default_api.file(brief="Create the IAM Identity Center SSO configuration guide.", action="write", path="/home/ubuntu/AWS_IAM_IDENTITY_CENTER_GUIDE.md", text='''# CloudGuard Portfolio: IAM Identity Center (SSO) Configuration Guide

This guide provides a step-by-step walkthrough for configuring AWS IAM Identity Center (formerly AWS Single Sign-On) for your CloudGuard Portfolio organization. This is a critical step for establishing secure, centralized, and manageable access to all your AWS accounts.

---

## 1. Introduction

IAM Identity Center is the recommended approach for managing human user access to AWS accounts and applications. It allows you to create or connect your workforce identities and manage their access centrally across your AWS Organization [1].

**Key Benefits:**

-   **Centralized Access Management:** Manage users and permissions for all accounts from a single place.
-   **No Long-Lived Credentials:** Users get temporary, automatically rotating credentials, which is a major security improvement over static IAM user keys.
-   **Improved User Experience:** Provides a single user portal to access all assigned AWS accounts and roles.
-   **Integration with AWS Organizations:** Seamlessly integrates with your multi-account structure.

This guide will help you set up users, groups, and permission sets to provide role-based access to your accounts.

---

## 2. Prerequisites

-   **AWS Organization Setup:** You must have completed the `AWS_ORGANIZATIONS_SETUP_GUIDE.md`.
-   **Root User Access:** You will need root user access to the management account to enable IAM Identity Center for the first time.

---

## 3. Step-by-Step Configuration

### Step 1: Enable IAM Identity Center

This is a one-time action performed in your management account.

1.  **Log in** to the AWS Management Console of your management account as the **root user**.
2.  Navigate to the **IAM Identity Center** service.
3.  On the splash screen, click **"Enable"**.
4.  You will be guided through a setup wizard. For the identity source, choose **"IAM Identity Center directory"**. This is the simplest option and allows you to create users and groups directly within IAM Identity Center.
5.  Complete the setup. IAM Identity Center will now be enabled for your organization.

### Step 2: Create User Groups

Creating groups is the best practice for managing permissions. You assign permissions to groups, and then add users to those groups.

1.  In the IAM Identity Center console, navigate to **"Groups"** on the left-hand menu.
2.  Click **"Create group"**.
3.  Create the following groups to start:

| Group Name | Description |
| :--- | :--- |
| `AWS-Administrators` | For users who need full administrative access across all accounts. |
| `AWS-PowerUsers` | For users who need broad permissions but not full admin rights (e.g., for development). |
| `AWS-ReadOnly` | For users who only need to view resources and configurations. |
| `AWS-Billing` | For users who need access to billing and cost management data. |

### Step 3: Create Users

Now, create your own user account. You will use this for all your daily work instead of the root user.

1.  In the IAM Identity Center console, navigate to **"Users"** on the left-hand menu.
2.  Click **"Add user"**.
3.  Fill in the user details:
    -   **Username:** e.g., `manus`
    -   **Email address:** Your primary email address.
    -   **First name / Last name:** Your details.
4.  Click **"Next"**.
5.  Add the user to the **`AWS-Administrators`** group.
6.  Click **"Next"** and then **"Add user"**.
7.  You will receive an email invitation to set your password. Follow the link to complete the user setup.

**Security Best Practice:** Log out of the root user and log back in as your new IAM Identity Center user for all subsequent steps.

### Step 4: Create Permission Sets

Permission Sets are templates that define a collection of permissions. They are analogous to IAM Roles.

1.  In the IAM Identity Center console, navigate to **"Permission sets"** under the **"Multi-account permissions"** section.
2.  Click **"Create permission set"**.
3.  Choose **"Predefined permission set"** and create the following:

| Predefined Policy | Permission Set Name (Suggestion) |
| :--- | :--- |
| `AdministratorAccess` | `AWSAdministratorAccess` |
| `PowerUserAccess` | `AWSPowerUserAccess` |
| `ReadOnlyAccess` | `AWSReadOnlyAccess` |
| `Billing` | `AWSBillingAccess` |

This creates permission sets that mirror the standard AWS managed policies.

### Step 5: Assign Groups and Permission Sets to Accounts

This is the final step where you grant access.

1.  In the IAM Identity Center console, navigate to **"AWS accounts"**.
2.  Select the checkbox next to an OU or a specific account. For initial setup, let's assign access to the **`Foundation`** OU.
3.  Click the **"Assign users or groups"** button.
4.  Select the **"Groups"** tab.
5.  Check the box next to the **`AWS-Administrators`** group and click **"Next"**.
6.  Select the **`AWSAdministratorAccess`** permission set and click **"Next"**.
7.  Review the assignment and click **"Submit"**. IAM Identity Center will now provision the necessary roles in all accounts within the `Foundation` OU.

Repeat this process to grant different levels of access as needed. For example, you might grant the `AWS-ReadOnly` group access to all accounts in the `Workloads` OU.

---

## 4. Accessing Your Accounts

Once the setup is complete, you can access your accounts via the AWS access portal.

1.  Navigate to the **AWS access portal URL** found on the IAM Identity Center dashboard.
2.  Log in with your newly created user credentials.
3.  You will see a list of all the AWS accounts and roles you have been assigned.
4.  Click on an account/role combination to get one-click access to the AWS Management Console or to get temporary command-line credentials.

---

## 5. Next Steps

Your organization now has a secure and scalable access management foundation. The next step is to automate the creation of your workload accounts.

-   **Proceed to the `AWS_ACCOUNT_AUTOMATION_GUIDE.md`** to learn how to script the creation of your "just-in-time" workload accounts using the AWS CLI or SDK.

---

## References

[1] AWS. (2023). *What is IAM Identity Center?* AWS IAM Identity Center User Guide. [https://docs.aws.amazon.com/singlesignon/latest/userguide/what-is.html](https://docs.aws.amazon.com/singlesignon/latest/userguide/what-is.html)
'''))<execute_tool>f-8"?>
