'''# CloudGuard Portfolio: AWS Organizations Setup Guide

This guide provides a step-by-step walkthrough for setting up your AWS Organization. Following these instructions will create a well-architected, multi-account environment that aligns with enterprise best practices and the account strategy previously defined.

---

## 1. Introduction

AWS Organizations is an account management service that enables you to consolidate multiple AWS accounts into an organization that you create and centrally manage [1]. This setup is foundational for establishing robust security, governance, and cost management across your CloudGuard Portfolio project.

> "With AWS Organizations, you can create service control policies (SCPs) that centrally control AWS service use across multiple AWS accounts. You can also use Organizations to help automate AWS account creation and to group your accounts to meet your budgetary, security, or compliance needs." [2]

This guide will help you create the following structure:

```
Root
└── 📂 Foundation (OU)
    ├── ☁️ cloudguard-foundation-management (Management Account)
    ├── ☁️ cloudguard-foundation-logarchive
    ├── ☁️ cloudguard-foundation-security
    ├── ☁️ cloudguard-foundation-networking
    └── ☁️ cloudguard-foundation-portfolio
└── 📂 Sandbox (OU)
    └── ☁️ cloudguard-sandbox-main
└── 📂 Workloads (OU)
    ├── ☁️ cloudguard-workloads-ml-01
    ├── ☁️ cloudguard-workloads-security-01
    ├── ☁️ cloudguard-workloads-app-arch-01
    ├── ☁️ cloudguard-workloads-cicd-01
    └── ☁️ cloudguard-workloads-genai-01
```

---

## 2. Prerequisites

Before you begin, ensure you have the following:

- **A new AWS Account:** This will become your **Management Account**. It should be a fresh account with no production workloads.
- **A unique email address:** For the management account. Use the alias `your.email+cloudguard-foundation-management@gmail.com`.
- **Root User Access:** You will need the root user credentials for the management account to enable AWS Organizations and IAM Identity Center.

**Security Best Practice:** Once the initial setup is complete, avoid using the root user for daily tasks. Rely on the IAM Identity Center users you will create later.

---

## 3. Step-by-Step Setup Process

### Step 1: Create the Organization

First, you will create the organization from your designated management account.

1.  **Log in** to the AWS Management Console of your management account as the **root user**.
2.  Navigate to the **AWS Organizations** service.
3.  On the splash screen, click the **"Create an organization"** button.
4.  You will see a confirmation screen. Creating the organization is final and enables all features by default. Click **"Create organization"**.

Congratulations! Your organization is now active, with your current account set as the management account.

### Step 2: Create Organizational Units (OUs)

Next, create the OUs to structure your accounts logically.

1.  In the AWS Organizations console, on the left-hand side, click on **"AWS Accounts"**.
2.  Select the **"Root"** organizational unit.
3.  On the right-hand side, click the **"Actions"** button, then select **"Create new"** under **"Organizational unit"**.
4.  Create the following three OUs one by one:

| OU Name | Purpose |
| :--- | :--- |
| `Foundation` | For core infrastructure and shared services accounts. |
| `Sandbox` | For experimentation and non-critical development. |
| `Workloads` | For project-specific, ephemeral accounts. |

Your OU structure under "Root" should now show `Foundation`, `Sandbox`, and `Workloads`.

### Step 3: Create Member Accounts

Now, you will create the initial set of member accounts. We will start with the `Foundation` and `Sandbox` accounts.

1.  In the AWS Organizations console, click the **"Add an AWS account"** button.
2.  Select **"Create an AWS account"**.
3.  Fill in the account creation form for each account, using the names and email aliases defined in the `AWS_ACCOUNT_STRATEGY.md` document.

    - **AWS account name:** e.g., `cloudguard-foundation-logarchive`
    - **Email address of the account's root user:** e.g., `your.email+cloudguard-foundation-logarchive@gmail.com`
    - **IAM role name:** Leave the default `OrganizationAccountAccessRole`. This allows you to access the member account from the management account.

4.  Click **"Create AWS account"**. Repeat this process for all 5 initial member accounts:

    - `cloudguard-foundation-logarchive`
    - `cloudguard-foundation-security`
    - `cloudguard-foundation-networking`
    - `cloudguard-foundation-portfolio`
    - `cloudguard-sandbox-main`

**Note:** It may take a few minutes for each account to be created and appear in your organization.

### Step 4: Move Accounts into OUs

Once the accounts are created, they will appear under the "Root" OU. You need to move them to their correct destination.

1.  In the **"AWS Accounts"** view, select the checkbox next to an account (e.g., `cloudguard-foundation-logarchive`).
2.  Click the **"Actions"** button, then select **"Move"** under **"AWS account"**.
3.  A dialog will appear. Select the destination OU (e.g., `Foundation`) and click **"Move AWS account"**.
4.  Repeat this process to organize all your accounts:

| Account Name | Destination OU |
| :--- | :--- |
| `cloudguard-foundation-logarchive` | `Foundation` |
| `cloudguard-foundation-security` | `Foundation` |
| `cloudguard-foundation-networking` | `Foundation` |
| `cloudguard-foundation-portfolio` | `Foundation` |
| `cloudguard-sandbox-main` | `Sandbox` |

Your organizational structure is now correctly configured.

---

## 4. Next Steps

With your AWS Organization and account structure in place, the next critical step is to configure centralized user access.

- **Proceed to the `AWS_IAM_IDENTITY_CENTER_GUIDE.md`** to set up Single Sign-On (SSO) for secure, manageable access to all your accounts without needing to create IAM users in each one.

---

## References

[1] AWS. (2023). *What is AWS Organizations?* AWS Organizations User Guide. [https://docs.aws.amazon.com/organizations/latest/userguide/orgs_introduction.html](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_introduction.html)

[2] AWS. (2023). *AWS Organizations features*. AWS Organizations User Guide. [https://docs.aws.amazon.com/organizations/latest/userguide/orgs_features.html](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_features.html)
'''))<execute_tool>print(default_api.file(brief="Create the AWS Organizations setup guide document.", action="write", path="/home/ubuntu/AWS_ORGANIZATIONS_SETUP_GUIDE.md", text='''# CloudGuard Portfolio: AWS Organizations Setup Guide

This guide provides a step-by-step walkthrough for setting up your AWS Organization. Following these instructions will create a well-architected, multi-account environment that aligns with enterprise best practices and the account strategy previously defined.

---

## 1. Introduction

AWS Organizations is an account management service that enables you to consolidate multiple AWS accounts into an organization that you create and centrally manage [1]. This setup is foundational for establishing robust security, governance, and cost management across your CloudGuard Portfolio project.

> "With AWS Organizations, you can create service control policies (SCPs) that centrally control AWS service use across multiple AWS accounts. You can also use Organizations to help automate AWS account creation and to group your accounts to meet your budgetary, security, or compliance needs." [2]

This guide will help you create the following structure:

```
Root
└── 📂 Foundation (OU)
    ├── ☁️ cloudguard-foundation-management (Management Account)
    ├── ☁️ cloudguard-foundation-logarchive
    ├── ☁️ cloudguard-foundation-security
    ├── ☁️ cloudguard-foundation-networking
    └── ☁️ cloudguard-foundation-portfolio
└── 📂 Sandbox (OU)
    └── ☁️ cloudguard-sandbox-main
└── 📂 Workloads (OU)
    ├── ☁️ cloudguard-workloads-ml-01
    ├── ☁️ cloudguard-workloads-security-01
    ├── ☁️ cloudguard-workloads-app-arch-01
    ├── ☁️ cloudguard-workloads-cicd-01
    └── ☁️ cloudguard-workloads-genai-01
```

---

## 2. Prerequisites

Before you begin, ensure you have the following:

- **A new AWS Account:** This will become your **Management Account**. It should be a fresh account with no production workloads.
- **A unique email address:** For the management account. Use the alias `your.email+cloudguard-foundation-management@gmail.com`.
- **Root User Access:** You will need the root user credentials for the management account to enable AWS Organizations and IAM Identity Center.

**Security Best Practice:** Once the initial setup is complete, avoid using the root user for daily tasks. Rely on the IAM Identity Center users you will create later.

---

## 3. Step-by-Step Setup Process

### Step 1: Create the Organization

First, you will create the organization from your designated management account.

1.  **Log in** to the AWS Management Console of your management account as the **root user**.
2.  Navigate to the **AWS Organizations** service.
3.  On the splash screen, click the **"Create an organization"** button.
4.  You will see a confirmation screen. Creating the organization is final and enables all features by default. Click **"Create organization"**.

Congratulations! Your organization is now active, with your current account set as the management account.

### Step 2: Create Organizational Units (OUs)

Next, create the OUs to structure your accounts logically.

1.  In the AWS Organizations console, on the left-hand side, click on **"AWS Accounts"**.
2.  Select the **"Root"** organizational unit.
3.  On the right-hand side, click the **"Actions"** button, then select **"Create new"** under **"Organizational unit"**.
4.  Create the following three OUs one by one:

| OU Name | Purpose |
| :--- | :--- |
| `Foundation` | For core infrastructure and shared services accounts. |
| `Sandbox` | For experimentation and non-critical development. |
| `Workloads` | For project-specific, ephemeral accounts. |

Your OU structure under "Root" should now show `Foundation`, `Sandbox`, and `Workloads`.

### Step 3: Create Member Accounts

Now, you will create the initial set of member accounts. We will start with the `Foundation` and `Sandbox` accounts.

1.  In the AWS Organizations console, click the **"Add an AWS account"** button.
2.  Select **"Create an AWS account"**.
3.  Fill in the account creation form for each account, using the names and email aliases defined in the `AWS_ACCOUNT_STRATEGY.md` document.

    - **AWS account name:** e.g., `cloudguard-foundation-logarchive`
    - **Email address of the account's root user:** e.g., `your.email+cloudguard-foundation-logarchive@gmail.com`
    - **IAM role name:** Leave the default `OrganizationAccountAccessRole`. This allows you to access the member account from the management account.

4.  Click **"Create AWS account"**. Repeat this process for all 5 initial member accounts:

    - `cloudguard-foundation-logarchive`
    - `cloudguard-foundation-security`
    - `cloudguard-foundation-networking`
    - `cloudguard-foundation-portfolio`
    - `cloudguard-sandbox-main`

**Note:** It may take a few minutes for each account to be created and appear in your organization.

### Step 4: Move Accounts into OUs

Once the accounts are created, they will appear under the "Root" OU. You need to move them to their correct destination.

1.  In the **"AWS Accounts"** view, select the checkbox next to an account (e.g., `cloudguard-foundation-logarchive`).
2.  Click the **"Actions"** button, then select **"Move"** under **"AWS account"**.
3.  A dialog will appear. Select the destination OU (e.g., `Foundation`) and click **"Move AWS account"**.
4.  Repeat this process to organize all your accounts:

| Account Name | Destination OU |
| :--- | :--- |
| `cloudguard-foundation-logarchive` | `Foundation` |
| `cloudguard-foundation-security` | `Foundation` |
| `cloudguard-foundation-networking` | `Foundation` |
| `cloudguard-foundation-portfolio` | `Foundation` |
| `cloudguard-sandbox-main` | `Sandbox` |

Your organizational structure is now correctly configured.

---

## 4. Next Steps

With your AWS Organization and account structure in place, the next critical step is to configure centralized user access.

- **Proceed to the `AWS_IAM_IDENTITY_CENTER_GUIDE.md`** to set up Single Sign-On (SSO) for secure, manageable access to all your accounts without needing to create IAM users in each one.

---

## References

[1] AWS. (2023). *What is AWS Organizations?* AWS Organizations User Guide. [https://docs.aws.amazon.com/organizations/latest/userguide/orgs_introduction.html](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_introduction.html)

[2] AWS. (2023). *AWS Organizations features*. AWS Organizations User Guide. [https://docs.aws.amazon.com/organizations/latest/userguide/orgs_features.html](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_features.html)
'''))</execute_tool>f-8"?>
